<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    */

    include "../../include/includeBaseControllerComponenti.php";
    include "../../../../gUtil/GestoreUpload.php";
    include "../../../../gUtil/ElaboratoreImmagini.php";
    include "../classi/Profili.php";
    
    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $visualizzatoreProfili = new Profili($geecomDb, filter_input(INPUT_POST, "id"));
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $visualizzatoreProfili = new Profili($geecomDb, filter_input(INPUT_GET, "id"));
    }
    
    $impostazioni = recuperaImpostazioni($geecomDb);
    
    switch ($operazione) {
        case 'crea':
            $visualizzatoreProfili->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $visualizzatoreProfili->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $visualizzatoreProfili->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES));
            $visualizzatoreProfili->setAspectRatio(filter_input(INPUT_POST,"aspectRatio",FILTER_SANITIZE_STRING));
            $visualizzatoreProfili->setAspetto(filter_input(INPUT_POST,"aspetto",FILTER_SANITIZE_STRING));
            $visualizzatoreProfili->crea();
            header("Location: ../creaProfili.php?id={$visualizzatoreProfili->getId()}&status=200");
            break;
        case 'modifica':
            $visualizzatoreProfili->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $visualizzatoreProfili->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $visualizzatoreProfili->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES));
            $visualizzatoreProfili->setAspectRatio(filter_input(INPUT_POST,"aspectRatio",FILTER_SANITIZE_STRING));
            $visualizzatoreProfili->setAspetto(filter_input(INPUT_POST,"aspetto",FILTER_SANITIZE_STRING));
            $visualizzatoreProfili->modifica();
            header("Location: ../creaProfili.php?id={$visualizzatoreProfili->getId()}&status=250");
            break;
        case 'elimina':
            $visualizzatoreProfili->elimina();
            echo "ok";
            break;
        case 'duplica':
            $visualizzatoreProfili->caricaDatiDalDatabase();
            $idNuovaForm = $visualizzatoreProfili->duplica();
            header("Location: ../creaProfili.php?id={$idNuovaForm}&status=260");
            break;
        case 'duplicaElemento':
            $idNuovoElemento = $visualizzatoreProfili->duplicaElemento(filter_input(INPUT_GET,"idElemento",FILTER_SANITIZE_NUMBER_INT));
            header("Location: ../creaElemento.php?id={$idNuovoElemento}&status=210");
            break;
        case 'creaElemento':
            $nome  = filter_input(INPUT_POST, "nome",FILTER_SANITIZE_STRING);
            $ruolo = filter_input(INPUT_POST, "ruolo",FILTER_SANITIZE_STRING);
            $descrizione = filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES);
            $visualizzatoreProfili->creaElemento($nome,$ruolo,$descrizione);
            echo "ok";
            break;
        case 'spostaElemento':
            $visualizzatoreProfili->spostaElemento(filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT),filter_input(INPUT_POST, "posizione",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
        case 'modificaElemento':
            $idElemento  = filter_input(INPUT_POST,"idElemento",FILTER_SANITIZE_STRING);
            $nome        = filter_input(INPUT_POST,"nome",FILTER_SANITIZE_STRING);
            $ruolo       = filter_input(INPUT_POST,"ruolo",FILTER_SANITIZE_STRING);
            $azienda     = filter_input(INPUT_POST,"azienda",FILTER_SANITIZE_STRING);
            $email       = filter_input(INPUT_POST,"email",FILTER_SANITIZE_STRING);
            $descrizione = filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES);
            $facebook    = filter_input(INPUT_POST,"facebook",FILTER_SANITIZE_STRING);
            $instagram   = filter_input(INPUT_POST,"instagram",FILTER_SANITIZE_STRING);
            $twitter     = filter_input(INPUT_POST,"twitter",FILTER_SANITIZE_STRING);
            $linkedin    = filter_input(INPUT_POST,"linkedin",FILTER_SANITIZE_STRING);
            
            $visualizzatoreProfili->modificaElemento($idElemento,$nome, $ruolo, $azienda,$email,$descrizione,$facebook,$instagram,$twitter,$linkedin);
            header("Location: ../creaElemento.php?id={$idElemento}&status=200");
            break;
        case 'stampaElementi':
            $visualizzatoreProfili->stampaElementi();
            break;
        case 'modificaImmagineElemento':
            $idElemento      = filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT);
            $tipiFileAmmessi = array("image/png","image/jpeg","image/webp","image/gif");
            $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../../../../immagini/altro", 0);
            $esitoUpload  = $gestoreUpload->salvaFile();
            if($esitoUpload["fileElaborati"]==1) {
                if($esitoUpload["percorso"]!="") {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                }
                // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                    $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                    if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                        $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                    }
                }
            }
            else {
                $percorsoFoto = "";
            }
            $visualizzatoreProfili->cambiaImmagineElemento($idElemento,$percorsoFoto);
            
            // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
            if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                    $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                }
            }

            if($impostazioni["generaThumbnail"]=="si") {
                $percorsoFileThumbnail = str_replace("immagini/","immagini/thumbnail/",$esitoUpload["percorso"]);
                $percorsoThumbnail = str_replace("../","",$percorsoFileThumbnail);
                $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaThumbnail"], $percorsoFileThumbnail);
            }
            
            echo "../../../$percorsoFoto";
            break;
        case 'eliminaImmagineElemento':
            $idElemento      = filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT);
            $visualizzatoreProfili->cambiaImmagineElemento($idElemento,'');
            echo "ok";
            break;
        case 'modificaImmagineElementoConPercorso':
            $idElemento = filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT);
            $percorso   = filter_input(INPUT_POST, "percorso",FILTER_SANITIZE_STRING);
            $visualizzatoreProfili->cambiaImmagineElemento($idElemento,$percorso);
            echo "ok";
            break;
        case 'eliminaElemento':
            $visualizzatoreProfili->eliminaElemento(filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
    }
